rm(list=ls())
library(lattice)
library(sp)
library(DAAG)
#--------------------------------------------------------------------------
#   Einstellung von Graphikparametern
#--------------------------------------------------------------------------
par(mfrow=c(1,1))
#
trellis.par.set(theme = col.whitebg())
axis.line <- trellis.par.get("axis.line");axis.line$col <- "black";axis.line$lwd <- 4;
trellis.par.set("axis.line", axis.line)
par.ylab.text <- trellis.par.get("par.ylab.text");par.ylab.text$cex <- 1.4;
trellis.par.set("par.ylab.text", par.ylab.text)
par.xlab.text <- trellis.par.get("par.xlab.text");par.xlab.text$cex <- 1.4;
trellis.par.set("par.xlab.text", par.xlab.text)
fontsize <- trellis.par.get("fontsize");fontsize$text =14;
trellis.par.set("fontsize", fontsize)
axis.text <- trellis.par.get("axis.text");axis.text$cex =1.4;
trellis.par.set("axis.text", axis.text)
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
filename <- file.choose()
dat <- read.table(filename,header=TRUE)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
dat1 <- dat
dat1[1:5,]
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat1[,1]
Y <- dat1[,2]
plot(X,Y,asp=1,main="Lage der Messpunkte",pch=13,cex=1.5,col="blue",lwd=2)
pause()
#--------------------------------------------------------------------------
#   Elementarstatistik
#--------------------------------------------------------------------------
summary(dat1)
#par(ask=T) # damit Graphiken nicht durchrauschen
plot(dat1[,c(3:7)])
par(mfrow=c(1,5))
boxplot(dat1[,3],lwd = 2,col = "blue",notch = T, main = "Precipitation")
boxplot(dat1[,4],lwd = 2,col = "red",notch = T, main = "Electr. Conduct.")
boxplot(dat1[,5],lwd = 2,col = "green",notch = T, main = "pH")
boxplot(dat1[,6],lwd = 2,col = "grey",notch = T, main = "Nitrate Conc.")
boxplot(dat1[,7],lwd = 2,col = "yellow",notch = T, main = "Nitrate Flux")
#--------------------------------------------------------------------------
#   Rumliche Muster
#--------------------------------------------------------------------------
# Farbcodiert
coordinates(dat1) <- c("X","Y")
spplot(dat1, "P", cex=1.5, main = "Niederschlag", key.space="bottom")
par(mfrow=c(1,1))
#
#   --- Schluss ---
#